package music;
import java.util.GregorianCalendar;

import art.Artwork;
import art.poetry.Poem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public class Song implements Artwork, Serializable {
	
	private static final long serialVersionUID = 7845654L;
    
    public static String definition;
    
    private String title;
    private String author;
    private int year;
    private GregorianCalendar releaseDate;
    
    static {
        definition = "Song is a nice piece of music.";
    }
    
    public Song(String title, String author, int year, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.releaseDate = releaseDate;
    }
    
    public Song(String title, String author, GregorianCalendar releaseDate) {
        this.title = title;
        this.author = author;
        this.releaseDate = releaseDate;
        this.year = this.releaseDate.YEAR;
    }
    
    public Song(String title, String author, int year) {
        this.title = title;
        this.author = author;
        this.year = year;
    }
    
//     public Song(String title, String author, int year) {
//         this.author = author;
//     }
    
    public Song(String title, String author) {
        this.title = title;
        this.author = author;
    }
    
    public Song() {
    }
    
    public static void define() {
        System.out.println("Song is a nice piece of music.");
    }
    
    public void display() {
        System.out.println('\"' + title + '\"' + ':' + '\n' +
                           '\t' + "author: " + author + '\n' +
                           '\t' + "year: " + year);
    }
    
    public void serialize(String filename) {
    	try {
			ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(filename)));
			out.writeObject(this);
			out.flush();
			out.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    
    public static Song deserialize(String filename) {
    	Song s = null;
    	try {
			ObjectInputStream in = new ObjectInputStream(new FileInputStream(new File(filename)));
			s = (Song) in.readObject();
			in.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return s;
    }
    
    public String toString() {
//         return this.title + ", " + this.author + " (" + this.year + ")";
        return this.title + ", " + this.author + " (" + (new SimpleDateFormat("MMM dd, yyyy")).format(this.releaseDate.getTime()) + ")";
    }
    
    @Override
    public void describe() {
    	System.out.println('\"' + title + '\"' + " is a nice song");
    }
    
    @Override
    public void showDate() {
    	System.out.println("released on " + (new SimpleDateFormat("MMM dd, yyyy")).format(this.releaseDate.getTime()));
    }
    
//    public Artwork showArtwork() {
////    	return this;
//    	return new Poem();
//    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(String author) {
        this.author = author;
    }
    
    public String getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setReleaseDate(GregorianCalendar releaseDate) {
        this.releaseDate = releaseDate;
    }
    
    public GregorianCalendar getReleaseDate() {
        return this.releaseDate;
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((author == null) ? 0 : author.hashCode());
		result = prime * result + ((releaseDate == null) ? 0 : releaseDate.hashCode());
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		result = prime * result + year;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Song other = (Song) obj;
		if (author == null) {
			if (other.author != null)
				return false;
		} else if (!author.equals(other.author))
			return false;
		if (releaseDate == null) {
			if (other.releaseDate != null)
				return false;
		} else if (!releaseDate.equals(other.releaseDate))
			return false;
		if (title == null) {
			if (other.title != null)
				return false;
		} else if (!title.equals(other.title))
			return false;
		if (year != other.year)
			return false;
		return true;
	}

}
